/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.util.math;

import lib.toma.animations.AnimationUtils;
import net.minecraft.util.math.MathHelper;

public final class Mth {
    public static float invert(float value) {
        return 1.0f - value;
    }

    public static float linearLineRising(float value, float minBound, float maxBound) {
        return (value - minBound) / (maxBound - minBound);
    }

    public static float linearLineFalling(float value, float minBound, float maxBound) {
        return Mth.invert(Mth.linearLineRising(value, minBound, maxBound));
    }

    public static float triangleFunc(float input) {
        return input <= 0.5f ? Mth.linearLineRising(input, 0.0f, 0.5f) : Mth.linearLineFalling(input, 0.5f, 1.0f);
    }

    public static float asLinearFunction(int value, int min, int max) {
        float f = (float)(value - min) / (float)(max - min);
        return MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
    }

    public static float asLinearInterpolatedFunction(int value, int min, int max, float partial) {
        if (value > max) {
            return 1.0f;
        }
        int old = value - 1;
        float f1 = Mth.asLinearFunction(value, min, max);
        float f2 = Mth.asLinearFunction(old, min, max);
        return AnimationUtils.linearInterpolate(f1, f2, partial);
    }

    public static int isWithinOrDefault(int value, int min, int max, int _default) {
        if (value >= min && value <= max) {
            return value;
        }
        return _default;
    }

    private Mth() {
    }
}

